package com.company.tp07_02_localtodoapp2.view.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.company.tp07_02_localtodoapp2.R;
import com.company.tp07_02_localtodoapp2.database.Todo;

import java.util.List;

public class TodoListAdapter extends BaseAdapter {
    private List<Todo> items;
    private int rowLayout;
    private Context context;

    public TodoListAdapter(Context context, int rowLayout, List<Todo> movies) {
        this.items = movies;
        this.rowLayout = rowLayout;
        this.context = context;
    }

    public void setItems(List<Todo> items) {
        this.items = items;
    }

    @Override
    public int getCount() {
        return items.size();
    }

    @Override
    public Object getItem(int position) {
        return items.get(position);
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        View rowView;
        LayoutInflater inflater = (LayoutInflater)context.getSystemService(Context.
                LAYOUT_INFLATER_SERVICE);
        rowView = inflater.inflate(this.rowLayout, null);

        TextView id = (TextView) rowView.findViewById(R.id.id);
        TextView title = (TextView) rowView.findViewById(R.id.title);
        ImageView completed = (ImageView) rowView.findViewById(R.id.completed);

        Todo row = (Todo)getItem(position);
        id.setText(String.valueOf(row.getId()));

        title.setText(row.getTitle());
        if(row.getCompleted()){
            completed.setImageDrawable(context.getDrawable(R.drawable.outline_fact_check_black_24dp));
        }else{
            completed.setImageDrawable(context.getDrawable(R.drawable.outline_assignment_black_24dp));
        }


        return rowView;
    }
}
